import { world } from "@minecraft/server";
export function clamp(n, min, max) {
    if (n < min)
        n = min;
    if (n > max)
        n = max;
    return n;
}
export function isMultiple(n, m) {
    return n % m === 0;
}
export function sqrDistance(point1, point2) {
    const dx = point1.x - point2.x;
    const dy = point1.y - point2.y;
    const dz = point1.z - point2.z;
    return dx * dx + dy * dy + dz * dz;
}
export function indexOfSmallestArrayElement(array) {
    // Initialize variables to store the smallest number and its index
    let smallestNumber = array[0];
    let smallestIndex = 0;
    // Iterate through the array to find the smallest number and its index
    for (let i = 1; i < array.length; i++) {
        if (array[i] < smallestNumber) {
            smallestNumber = array[i];
            smallestIndex = i;
        }
    }
    return smallestIndex;
}
export function getClosestEntityFromLocation(eqo, dimension, location) {
    let resultEntity;
    let entities = dimension.getEntities(eqo);
    if (entities.length === 0)
        return undefined;
    let resultDistances = new Array(entities.length);
    for (let i = 0; i < entities.length; i++) {
        const entity = entities[i];
        resultDistances[i] = sqrDistance(entity.location, location);
    }
    resultEntity = entities[indexOfSmallestArrayElement(resultDistances)];
    return resultEntity;
}
export function getClosestPlayerFromLocation(defaultPlayer, location) {
    let resultPlayer = defaultPlayer;
    let players = world.getPlayers();
    if (players.length === 1)
        return resultPlayer;
    let resultDistances = new Array(players.length);
    for (let i = 0; i < players.length; i++) {
        const player = players[i];
        resultDistances[i] = sqrDistance(player.location, location);
    }
    resultPlayer = players[indexOfSmallestArrayElement(resultDistances)];
    return resultPlayer;
}
export function vector3ToString(value) {
    return `(${Math.floor(value.x)}, ${Math.floor(value.y)}, ${Math.floor(value.z)})`;
}
